<?php
/**
 * Siparişi E-Ticaret API'sine Gönder
 * Tek sipariş veya toplu sipariş gönderimi için endpoint
 */

require_once 'config.php';
require_once 'api_client.php';

header('Content-Type: application/json; charset=utf-8');

try {
    // Sipariş ID veya Order Code kontrolü
    $orderId = isset($_GET['id']) ? (int)$_GET['id'] : null;
    $orderCode = isset($_GET['order_code']) ? trim($_GET['order_code']) : null;
    
    if (empty($orderId) && empty($orderCode)) {
        throw new Exception("Sipariş ID veya Order Code gerekli");
    }
    
    // Veritabanından siparişi getir
    $pdo = getDBConnection();
    
    if ($orderId) {
        $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = :id");
        $stmt->execute([':id' => $orderId]);
    } else {
        $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_code = :order_code");
        $stmt->execute([':order_code' => $orderCode]);
    }
    
    $order = $stmt->fetch();
    
    if (!$order) {
        throw new Exception("Sipariş bulunamadı");
    }
    
    // API'ye gönder
    $apiClient = new ECommerceAPIClient();
    $result = $apiClient->createOrder($order);
    
    // Sonuçları kaydet (isteğe bağlı - log tablosu oluşturabilirsiniz)
    if ($result['success']) {
        // Siparişin gönderildiğini işaretle (eğer tabloda api_sent kolonu varsa)
        // $updateStmt = $pdo->prepare("UPDATE orders SET api_sent = 1, api_sent_at = NOW() WHERE id = :id");
        // $updateStmt->execute([':id' => $order['id']]);
    }
    
    http_response_code($result['success'] ? 200 : 400);
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

