# E-Ticaret API Entegrasyonu Kılavuzu

Bu dokümantasyon, siparişlerinizi Cartelwind e-ticaret sistemine API ile gönderme işlemini açıklar.

## 📋 Gereksinimler

- PHP 7.4 veya üzeri
- cURL extension aktif
- API Key ve API Secret (Cartelwind panelinden alınacak)

## 🔧 Kurulum

### 1. API Ayarlarını Yapılandırma

`api_config.php` dosyasını açın ve aşağıdaki bilgileri doldurun:

```php
define('API_BASE_URL', 'https://www.sizin-domain.com/api/v2');
define('API_KEY', 'your-api-key-here');
define('API_SECRET', 'your-api-secret-here');
```

**API Bilgilerini Nereden Alırım?**

1. Cartelwind yönetim paneline giriş yapın
2. **Ayarlar → Web Servis Ayarları** bölümüne gidin
3. Yeni bir web servis kullanıcısı oluşturun veya mevcut kullanıcıyı düzenleyin
4. **API Key** ve **API Secret** bilgilerini kopyalayın
5. `api_config.php` dosyasına yapıştırın

### 2. API Formatını Kontrol Edin

`api_client.php` dosyasındaki `convertOrderToAPIFormat()` fonksiyonu, sipariş verilerini API formatına dönüştürür. 

**ÖNEMLİ:** Cartelwind API dokümantasyonundaki `order/create` metodunun tam formatını kontrol edip, gerekirse bu fonksiyonu güncelleyin.

## 🚀 Kullanım

### Yöntem 1: Admin Panelinden Tekil Gönderim

1. Admin paneline giriş yapın: `admin.php`
2. Göndermek istediğiniz siparişin yanındaki **"📤 API'ye Gönder"** butonuna tıklayın
3. Onay verin
4. Sonuç mesajını kontrol edin

### Yöntem 2: API Endpoint ile Gönderim

```bash
# Sipariş ID ile
GET /send_order_to_api.php?id=123

# Sipariş Kodu ile
GET /send_order_to_api.php?order_code=642OS4MKA1IY
```

**cURL Örneği:**
```bash
curl "https://siparis.grantoys.com.tr/send_order_to_api.php?id=123"
```

### Yöntem 3: Toplu Gönderim

```bash
# Son 10 siparişi gönder
GET /bulk_send_orders.php?limit=10
```

**cURL Örneği:**
```bash
curl "https://siparis.grantoys.com.tr/bulk_send_orders.php?limit=10"
```

### Yöntem 4: PHP Kodundan Kullanım

```php
require_once 'api_client.php';

$apiClient = new ECommerceAPIClient();

// Veritabanından siparişi getir
$pdo = getDBConnection();
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = :id");
$stmt->execute([':id' => 123]);
$order = $stmt->fetch();

// API'ye gönder
$result = $apiClient->createOrder($order);

if ($result['success']) {
    echo "Sipariş gönderildi: " . $result['order_code'];
} else {
    echo "Hata: " . $result['message'];
}
```

## 📊 API Yanıt Formatı

### Başarılı Yanıt

```json
{
    "success": true,
    "message": "Sipariş başarıyla oluşturuldu",
    "order_code": "642OS4MKA1IY",
    "order_id": 12345,
    "response": {
        "code": "SUCCESS",
        "result": {
            "id": 12345,
            "orderCode": "642OS4MKA1IY"
        }
    }
}
```

### Hata Yanıtı

```json
{
    "success": false,
    "message": "API authentication failed"
}
```

## 🔍 Hata Ayıklama

### Debug Modu

`api_config.php` dosyasında debug modunu açın:

```php
define('API_DEBUG', true);
```

Bu mod açıkken, tüm API istekleri `api_logs/` klasörüne kaydedilir.

### Log Dosyaları

Log dosyaları şu formatta kaydedilir:
- Konum: `api_logs/YYYY-MM-DD.log`
- Format: JSON

Örnek log:
```json
{
    "timestamp": "2023-12-04 14:30:00",
    "endpoint": "order/create",
    "request": {...},
    "response": {...},
    "http_code": 200
}
```

### Yaygın Hatalar

1. **Authentication Failed**
   - API Key ve Secret'ı kontrol edin
   - API kullanıcısının aktif olduğundan emin olun

2. **Invalid JSON Response**
   - API URL'ini kontrol edin
   - SSL sertifikası sorunlarını kontrol edin

3. **Timeout**
   - `API_TIMEOUT` değerini artırın
   - Sunucu bağlantısını kontrol edin

## ⚙️ API Format Özelleştirme

Eğer Cartelwind API'sinin sipariş formatı farklıysa, `api_client.php` dosyasındaki `convertOrderToAPIFormat()` fonksiyonunu düzenleyin:

```php
private function convertOrderToAPIFormat($dbOrder) {
    // API dokümantasyonuna göre formatı düzenleyin
    return [
        'customer' => [...],
        'items' => [...],
        // ... diğer alanlar
    ];
}
```

## 📝 Notlar

- API rate limit'lerine dikkat edin
- Toplu gönderimlerde `usleep()` ile bekleme eklenmiştir
- Her sipariş gönderiminden sonra sonuçları kontrol edin
- Üretim ortamında `API_DEBUG` modunu kapatın

## 🔐 Güvenlik

- API Key ve Secret bilgilerini asla public repository'lere commit etmeyin
- `.gitignore` dosyasına `api_config.php` ekleyin
- HTTPS kullanın
- API kullanıcısına sadece gerekli yetkileri verin

## 📞 Destek

API entegrasyonu ile ilgili sorunlar için:
- Cartelwind API dokümantasyonunu inceleyin
- Log dosyalarını kontrol edin
- API yanıtlarını inceleyin

